# How to Remove Ollama Models

## Quick Commands

### List All Models
```bash
ollama list
```

This will show all installed models with their sizes, for example:
```
NAME            ID              SIZE    MODIFIED
llama3.1:8b     abc123def456    4.7 GB  2 hours ago
llama3.1:70b    def789ghi012    40.2 GB 1 day ago
```

### Remove a Single Model
```bash
# Remove a specific model by name
ollama rm llama3.1:8b
```

### Remove Multiple Models
```bash
# Remove multiple models at once
ollama rm llama3.1:8b llama3.1:70b mistral:7b
```

### Verify Removal
```bash
# Check that models are removed
ollama list
```

## Complete Cleanup

### Remove All Models
```bash
# Get list of all models and remove them
ollama list | awk 'NR>1 {print $1}' | xargs -I {} ollama rm {}
```

Or manually:
```bash
# List models first
ollama list

# Then remove each one
ollama rm model1
ollama rm model2
# ... etc
```

### Check Disk Space Before/After
```bash
# Check disk usage before removal
du -sh ~/.ollama/models/

# After removal, check again
du -sh ~/.ollama/models/
```

## Model Storage Location

Models are stored in:
- **Linux**: `~/.ollama/models/`
- **macOS**: `~/.ollama/models/`
- **Windows**: `%USERPROFILE%\.ollama\models\`

You can also manually delete model files from these directories if needed:
```bash
# View model files
ls -lh ~/.ollama/models/

# Manually remove (not recommended, use 'ollama rm' instead)
# rm -rf ~/.ollama/models/llama3.1:8b
```

## Troubleshooting

### Model Still Shows After Removal
```bash
# Force refresh
ollama list

# If still showing, check if Ollama service needs restart
# Stop Ollama
pkill ollama

# Start Ollama
ollama serve

# Check again
ollama list
```

### Cannot Remove Model (In Use)
If a model is currently being used, you may need to:
1. Stop any processes using the model
2. Wait for current operations to complete
3. Try removing again

### Check What's Using Disk Space
```bash
# Check total Ollama storage
du -sh ~/.ollama/

# Check individual model sizes
du -sh ~/.ollama/models/*/
```

## Example: Remove All Models Except One

If you want to keep only `llama3.1:8b` and remove others:

```bash
# List all models
ollama list

# Remove specific ones (keep llama3.1:8b)
ollama rm llama3.1:70b
ollama rm mistral:7b
# ... remove others as needed
```

## Re-downloading Models

If you remove a model but need it later:
```bash
# Simply pull it again
ollama pull llama3.1:8b
```

## Space Savings

Typical model sizes:
- **llama3.1:8b**: ~4.7 GB
- **llama3.1:70b**: ~40 GB
- **mistral:7b**: ~4.1 GB
- **codellama:7b**: ~3.8 GB

Removing unused models can free up significant disk space!



