# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class CloudAzureAiSearchVectorStore(pydantic.BaseModel):
    """
    Cloud Azure AI Search Vector Store.
    """

    supports_nested_metadata_filters: typing.Optional[bool]
    search_service_api_key: str
    search_service_endpoint: str
    search_service_api_version: typing.Optional[str]
    index_name: typing.Optional[str]
    filterable_metadata_field_keys: typing.Optional[typing.Dict[str, typing.Any]]
    embedding_dimension: typing.Optional[int]
    client_id: typing.Optional[str]
    client_secret: typing.Optional[str]
    tenant_id: typing.Optional[str]
    class_name: typing.Optional[str]

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
