# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class CloudQdrantVectorStore(pydantic.BaseModel):
    """
    Cloud Qdrant Vector Store.

    This class is used to store the configuration for a Qdrant vector store, so that it can be
    created and used in LlamaCloud.

    Args:
    collection_name (str): name of the Qdrant collection
    url (str): url of the Qdrant instance
    api_key (str): API key for authenticating with Qdrant
    max_retries (int): maximum number of retries in case of a failure. Defaults to 3
    client_kwargs (dict): additional kwargs to pass to the Qdrant client
    """

    supports_nested_metadata_filters: typing.Optional[bool]
    collection_name: str
    url: str
    api_key: str
    max_retries: typing.Optional[int]
    client_kwargs: typing.Optional[typing.Dict[str, typing.Any]]
    class_name: typing.Optional[str]

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
