# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .extract_config import ExtractConfig
from .extract_run_data import ExtractRunData
from .extract_run_data_schema_value import ExtractRunDataSchemaValue
from .extract_run_extraction_metadata_value import ExtractRunExtractionMetadataValue
from .extract_state import ExtractState
from .file import File

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class ExtractRun(pydantic.BaseModel):
    """
    Schema for an extraction run.
    """

    id: str = pydantic.Field(description="The id of the extraction run")
    created_at: typing.Optional[dt.datetime]
    updated_at: typing.Optional[dt.datetime]
    extraction_agent_id: str = pydantic.Field(description="The id of the extraction agent")
    data_schema: typing.Dict[str, typing.Optional[ExtractRunDataSchemaValue]] = pydantic.Field(
        description="The schema used for extraction"
    )
    config: ExtractConfig = pydantic.Field(description="The config used for extraction")
    file: File = pydantic.Field(description="The file that the extract was extracted from")
    status: ExtractState = pydantic.Field(description="The status of the extraction run")
    error: typing.Optional[str]
    job_id: typing.Optional[str]
    data: typing.Optional[ExtractRunData] = pydantic.Field(description="The data extracted from the file")
    extraction_metadata: typing.Optional[typing.Dict[str, typing.Optional[ExtractRunExtractionMetadataValue]]]
    from_ui: bool = pydantic.Field(description="Whether this extraction run was triggered from the UI")

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
