# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class FileIdPresignedUrl(pydantic.BaseModel):
    """
    Schema for a presigned URL with a file ID.
    """

    url: str = pydantic.Field(description="A presigned URL for IO operations against a private file")
    expires_at: dt.datetime = pydantic.Field(description="The time at which the presigned URL expires")
    form_fields: typing.Optional[typing.Dict[str, typing.Optional[str]]]
    file_id: str = pydantic.Field(description="The ID of the file associated with the presigned URL")

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
