# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .supported_llm_model_names import SupportedLlmModelNames

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class LlmParameters(pydantic.BaseModel):
    model_name: typing.Optional[SupportedLlmModelNames] = pydantic.Field(
        description="The name of the model to use for LLM completions."
    )
    system_prompt: typing.Optional[str]
    temperature: typing.Optional[float]
    use_chain_of_thought_reasoning: typing.Optional[bool]
    use_citation: typing.Optional[bool]
    class_name: typing.Optional[str]

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
