# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .extract_run import ExtractRun

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class PaginatedExtractRunsResponse(pydantic.BaseModel):
    """
    Schema for paginated extraction runs response.
    """

    items: typing.List[ExtractRun] = pydantic.Field(description="The list of extraction runs")
    total: int = pydantic.Field(description="The total number of extraction runs")
    skip: int = pydantic.Field(description="The number of extraction runs skipped")
    limit: int = pydantic.Field(description="The maximum number of extraction runs returned")

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
