# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .delete_params import DeleteParams

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class PipelineFileUpdaterConfig(pydantic.BaseModel):
    """
    Schema for the parameters of a load files job.
    """

    custom_metadata: typing.Optional[typing.Dict[str, typing.Any]]
    resource_info: typing.Optional[typing.Dict[str, typing.Any]]
    should_delete: typing.Optional[bool]
    should_parse: typing.Optional[bool]
    delete_info: typing.Optional[DeleteParams]
    is_new_file: typing.Optional[bool] = pydantic.Field(description="Whether the file is new")
    data_source_project_file_changed: typing.Optional[bool] = pydantic.Field(
        description="Whether the data source project file has changed"
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
